<?php
// api/install.php
require 'db.php';

try {
    $sql = "CREATE TABLE IF NOT EXISTS user_progress (
        id INTEGER PRIMARY KEY AUTO_INCREMENT, -- SQLite uses AUTOINCREMENT, MySQL uses AUTO_INCREMENT. This SQL might need adjustment for SQLite but works for MySQL.
        user_name VARCHAR(100) NOT NULL,
        app_id VARCHAR(50) NOT NULL,
        question_id VARCHAR(50) NOT NULL,
        is_correct TINYINT(1) NOT NULL,
        timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
    )";

    // Adjust for SQLite compatibility if local
    if ($is_local) {
        $sql = "CREATE TABLE IF NOT EXISTS user_progress (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_name TEXT NOT NULL,
            app_id TEXT NOT NULL,
            question_id TEXT NOT NULL,
            is_correct INTEGER NOT NULL,
            timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
        )";
    }

    $pdo->exec($sql);
    echo "Table 'user_progress' created successfully.";

} catch (PDOException $e) {
    echo "Error creating table: " . $e->getMessage();
}
?>
